async function salvarEdicaoComissao(comissaoId, btn) {
  const isc = document.getElementById(`edit-isc-${comissaoId}`).value;
  const meta = document.getElementById(`edit-meta-${comissaoId}`).value;
  const premio = document.getElementById(`edit-premio-${comissaoId}`).value;
  const grat = document.getElementById(`edit-grat-${comissaoId}`).value;
  const msgDiv = document.getElementById(`msg-edit-${comissaoId}`);
  msgDiv.innerText = '';
  if (btn) btn.disabled = true;
  try {
    const res = await fetch(`${API_URL}/comissoes/${comissaoId}`, {
      method: "PUT",
      headers: {
        "Content-Type": "application/json",
        Authorization: `Bearer ${getToken()}`
      },
      body: JSON.stringify({
        PREMIO_ISC: isc,
        PREMIACAO_META: meta,
        PREMIO: premio,
        GRATIFICACAO: grat
      })
    });
    const data = await res.json();
    if (res.ok) {
      msgDiv.innerText = data.msg || "Comissão atualizada!";
      msgDiv.className = "alert alert-success p-1 mt-1";
      if (window.carregarHistoricoComissoes) setTimeout(() => window.carregarHistoricoComissoes(), 1000);
    } else {
      msgDiv.innerText = data.msg || "Erro ao atualizar.";
      msgDiv.className = "alert alert-danger p-1 mt-1";
    }
  } catch (e) {
    msgDiv.innerText = "Erro de conexão.";
    msgDiv.className = "alert alert-danger p-1 mt-1";
  }
  if (btn) setTimeout(() => { btn.disabled = false; }, 1200);
}
// REGISTRO DE USUÁRIO (registrar.html)
async function registrarUsuario(event) {
  event.preventDefault();
  const nome = document.getElementById("nomeUsuario").value;
  const email = document.getElementById("emailUsuario").value;
  const senha = document.getElementById("senhaUsuario").value;
  const senha2 = document.getElementById("senhaUsuario2").value;
  const departamento = document.getElementById("departamentoUsuario").value;
  const role = document.getElementById("roleUsuario").value;
  const msgDiv = document.getElementById("msgRegistrarUsuario");
  if (senha !== senha2) {
    msgDiv.innerText = "As senhas não coincidem.";
    msgDiv.className = "alert alert-danger";
    return;
  }
  const res = await fetch(`${API_URL}/auth/register`, {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ nome, email, senha, departamento, role })
  });
  const data = await res.json();
  if (res.ok) {
    msgDiv.innerText = "Usuário cadastrado com sucesso!";
    msgDiv.className = "alert alert-success";
    document.getElementById("formRegistrarUsuario").reset();
  } else {
    msgDiv.innerText = data.msg || "Erro ao cadastrar usuário";
    msgDiv.className = "alert alert-danger";
  }
}
// Função para limpar cache quando necessário
function limparCacheUsuario() {
  localStorage.removeItem('user_data_cache');
  console.log('🧹 Cache do usuário limpo');
}

// Função para forçar atualização dos dados do usuário
async function forcarAtualizacaoUsuario() {
  limparCacheUsuario();
  await carregarSaudacaoUsuario();
}

// Carregar saudação do usuário autenticado e configurar navbar
async function carregarSaudacaoUsuario(forcarAtualizacao = false) {
  const saudacao = document.getElementById("saudacao-usuario");
  const token = getToken();
  
  console.log('🔄 Carregando saudação do usuário...', { forcarAtualizacao });
  
  if (!token) {
    console.log('❌ Token não encontrado');
    if (saudacao) saudacao.textContent = "";
    return;
  }

  if (!saudacao) {
    console.log('⚠️ Elemento saudacao-usuario não encontrado');
    return;
  }
  
  // Verificar cache apenas se não forçar atualização
  const cacheKey = 'user_data_cache';
  const cacheTime = 2 * 60 * 1000; // Reduzido para 2 minutos
  
  if (!forcarAtualizacao) {
    const cached = localStorage.getItem(cacheKey);
    if (cached) {
      try {
        const { data, timestamp } = JSON.parse(cached);
        if (Date.now() - timestamp < cacheTime) {
          console.log('📋 Usando dados do cache');
          aplicarDadosUsuario(data, saudacao, btnCadastro);
          return;
        } else {
          console.log('⏰ Cache expirado, buscando dados atualizados');
        }
      } catch (e) {
        console.log('💥 Cache corrompido, limpando...', e);
        localStorage.removeItem(cacheKey);
      }
    }
  } else {
    console.log('🔄 Forçando busca de dados atualizados');
    localStorage.removeItem(cacheKey);
  }
  
  try {
    console.log('🌐 Buscando dados do usuário na API...');
    const res = await fetch(`${API_URL}/auth/me`, {
      headers: { 
        Authorization: `Bearer ${token}`,
        'Cache-Control': 'no-cache',
        'Pragma': 'no-cache'
      }
    });
    
    if (res.ok) {
      const data = await res.json();
      console.log('✅ Dados do usuário recebidos:', data);
      
      // Aplicar dados na interface
      aplicarDadosUsuario(data, saudacao, null);
      
      // Salvar no cache
      localStorage.setItem(cacheKey, JSON.stringify({
        data: data,
        timestamp: Date.now()
      }));
      
    } else {
      console.log('❌ Resposta inválida da API:', res.status);
      saudacao.textContent = "";
      localStorage.removeItem(cacheKey);
      
      // Se não autorizado, redirecionar para login
      if (res.status === 401) {
        localStorage.removeItem("access_token");
        window.location.href = "/frontend/login.html";
      }
    }
  } catch (error) {
    console.error('� Erro ao buscar dados do usuário:', error);
    saudacao.textContent = "";
    if (btnCadastro) btnCadastro.style.display = 'none';
  }
}

// Função auxiliar para aplicar dados do usuário na interface
function aplicarDadosUsuario(data, saudacao, btnCadastro) {
  // Configurar saudação
  const primeiroNome = data.nome.split(' ')[0];
  saudacao.textContent = `Bem-vindo, ${primeiroNome}`;
  
  // Verificar se é admin (pela role OU departamento)
  const isAdmin = data.role === 'admin' || data.departamento === 'ADMINISTRAÇÃO';
  
  // Configurar card de cadastro de usuários no dashboard (só para admins)
  const cardCadastro = document.getElementById('card-cadastro');
  if (cardCadastro) {
    if (isAdmin) {
      cardCadastro.style.display = 'block';
      console.log('✅ Mostrando card cadastro no dashboard');
    } else {
      cardCadastro.style.display = 'none';
      console.log('❌ Escondendo card cadastro no dashboard');
    }
  }
  
  // Configurar card de registrar comissão no dashboard (todos podem ver)
  const cardRegistrar = document.getElementById('card-registrar');
  if (cardRegistrar) {
    cardRegistrar.style.display = 'block';
    console.log('✅ Mostrando card registrar no dashboard para todos');
  }
  
  // Configurar botão de navegação "Usuários" na navbar (só para admins)
  const navCadastro = document.getElementById('nav-cadastro');
  if (navCadastro) {
    if (isAdmin) {
      navCadastro.style.display = 'inline-block';
      console.log('✅ Mostrando botão Usuários na navbar');
    } else {
      navCadastro.style.display = 'none';
      console.log('❌ Escondendo botão Usuários na navbar');
    }
  }
  
  // Configurar botão de navegação "Registrar" na navbar (todos podem ver)
  const navRegistrar = document.getElementById('nav-registrar');
  if (navRegistrar) {
    navRegistrar.style.display = 'inline-block';
    console.log('✅ Mostrando botão Registrar na navbar para todos');
  }
}

// Inicializar navbar (função comum para todas as páginas)
async function inicializarNavbar(forcarAtualizacao = false) {
  console.log('🔧 Iniciando configuração da navbar...', { forcarAtualizacao });
  
  const token = getToken();
  if (!token) {
    console.log('❌ Token não encontrado, redirecionando para login...');
    window.location.href = "/frontend/login.html";
    return;
  }
  
  // Adicionar classe de loading para evitar flash
  document.body.classList.add('navbar-loading');
  
  // Esconder elementos temporariamente
  const saudacao = document.getElementById("saudacao-usuario");
  
  if (saudacao) {
    saudacao.style.opacity = '0';
    saudacao.style.visibility = 'hidden';
  }
  
  try {
    // Carregar saudação e configurar botões
    console.log('🔄 Carregando dados do usuário...');
    await carregarSaudacaoUsuario(forcarAtualizacao);
    console.log('✅ Navbar configurada com sucesso');
    
    // Mostrar elementos com transição suave
    if (saudacao) {
      saudacao.style.visibility = 'visible';
      saudacao.style.opacity = '1';
      saudacao.classList.add('loaded');
    }
    
  } catch (error) {
    console.error('💥 Erro ao configurar navbar:', error);
    
    // Fallback: mostrar algo básico mesmo com erro
    if (saudacao) {
      saudacao.textContent = "Usuário";
      saudacao.style.visibility = 'visible';
      saudacao.style.opacity = '1';
    }
  } finally {
    // Sempre remover classe de loading
    document.body.classList.remove('navbar-loading');
  }
}

// Função para reinicializar navbar quando necessário
async function reinicializarNavbar() {
  console.log('🔄 Reinicializando navbar com dados atualizados...');
  await inicializarNavbar(true);
}

// Logout
function logout() {
  console.log('👋 Fazendo logout...');
  
  // Limpar todos os dados do cache
  localStorage.removeItem("access_token");
  localStorage.removeItem("user_data_cache");
  
  // Limpar cache do navegador
  if ('caches' in window) {
    caches.keys().then(function(names) {
      for (let name of names) {
        caches.delete(name);
      }
    });
  }
  
  console.log('✅ Cache limpo, redirecionando...');
  window.location.href = "/frontend/login.html";
}
// CADASTRO DE USUÁRIO
async function cadastrarUsuario(event) {
  event.preventDefault();
  const id_colaborador = document.getElementById("idColaboradorUsuario").value;
  const nome = document.getElementById("nomeUsuario").value;
  const email = document.getElementById("emailUsuario").value;
  const senha = document.getElementById("senhaUsuario").value;
  const senha2 = document.getElementById("senhaUsuario2").value;
  const departamento = document.getElementById("departamentoUsuario").value;
  const role = document.getElementById("roleUsuario").value;

  const msgDiv = document.getElementById("msgCadastroUsuario");
  if (senha !== senha2) {
    msgDiv.innerText = "As senhas não coincidem.";
    msgDiv.className = "alert alert-danger";
    return;
  }


  const res = await fetch(`${API_URL}/auth/register`, {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ id_colaborador, nome, email, senha, departamento, role })
  });

  const data = await res.json();
  if (res.ok) {
    msgDiv.innerText = "Usuário cadastrado com sucesso!";
    msgDiv.className = "alert alert-success";
    document.getElementById("formCadastroUsuario").reset();
  } else {
    msgDiv.innerText = data.msg || "Erro ao cadastrar usuário";
    msgDiv.className = "alert alert-danger";
  }
}

// Conectar ao submit do formulário se existir na página
document.addEventListener("DOMContentLoaded", () => {
  const form = document.getElementById("formCadastroUsuario");
  if (form) {
    form.addEventListener("submit", cadastrarUsuario);
  }
});
const API_URL = "http://127.0.0.1:5000"; 

// Função para obter token atualizado
function getToken() {
  return localStorage.getItem("access_token");
}

// Configurar listeners para detectar problemas de cache
document.addEventListener('DOMContentLoaded', function() {
  // Listener para visibilitychange (quando usuário volta para a aba)
  document.addEventListener('visibilitychange', function() {
    if (!document.hidden) {
      console.log('👁️ Página ficou visível, verificando se precisa atualizar...');
      // Verificar se os dados estão desatualizados
      const cacheKey = 'user_data_cache';
      const cached = localStorage.getItem(cacheKey);
      if (cached) {
        try {
          const { timestamp } = JSON.parse(cached);
          const tempoDecorrido = Date.now() - timestamp;
          // Se passou mais de 1 minuto, forçar atualização
          if (tempoDecorrido > 60000) {
            console.log('⏰ Dados podem estar desatualizados, atualizando...');
            setTimeout(() => reinicializarNavbar(), 500);
          }
        } catch (e) {
          console.log('💥 Cache corrompido detectado, atualizando...');
          setTimeout(() => reinicializarNavbar(), 500);
        }
      }
    }
  });

  // Listener para storage changes (quando localStorage muda em outra aba)
  window.addEventListener('storage', function(e) {
    if (e.key === 'access_token' || e.key === 'user_data_cache') {
      console.log('🔄 Detectada mudança no storage, atualizando navbar...');
      setTimeout(() => reinicializarNavbar(), 200);
    }
  });

  // Listener para pageshow (quando página é restaurada do cache do navegador)
  window.addEventListener('pageshow', function(e) {
    if (e.persisted) {
      console.log('🔄 Página restaurada do cache, atualizando navbar...');
      setTimeout(() => reinicializarNavbar(), 300);
    }
  });
});

// LOGIN
async function login() {
  const email = document.getElementById("email").value;
  const senha = document.getElementById("senha").value;

  const res = await fetch(`${API_URL}/auth/login`, {
    method: "POST",
    headers: { "Content-Type": "application/json" },
    body: JSON.stringify({ email, senha })
  });

  const data = await res.json();
  if (res.ok) {
    console.log('✅ Login realizado com sucesso');
    
    // Limpar qualquer cache antigo antes de definir novo token
    localStorage.removeItem("user_data_cache");
    localStorage.setItem("access_token", data.access_token);
    
    console.log('🔄 Redirecionando para dashboard...');
    window.location.href = "/frontend/dashboard.html";
  } else {
    console.log('❌ Erro no login:', data.msg);
    document.getElementById("msg").innerText = data.msg || "Erro no login";
  }
}

// BUSCAR VENDEDOR
async function buscarVendedor() {
  const nome = document.getElementById("buscaNome").value;

  const res = await fetch(`${API_URL}/vendedores/buscar?nome=${nome}`, {
    headers: { Authorization: `Bearer ${getToken()}` }
  });

  const data = await res.json();
  const lista = document.getElementById("resultadoBusca");
  lista.innerHTML = "";

  data.forEach(v => {
    const li = document.createElement("li");
    li.classList.add("list-group-item");
    li.innerText = `${v.id} - ${v.nome} (${v.departamento})`;
    lista.appendChild(li);
  });
}

// REGISTRAR COMISSÃO
async function registrarComissao() {
  const vendedor_id = document.getElementById("vendedorId").value;
  const mes_referencia = document.getElementById("mes").value;
  const tipo1 = document.getElementById("tipo1").value;
  const tipo2 = document.getElementById("tipo2").value;
  const tipo3 = document.getElementById("tipo3").value;
  const tipo4 = document.getElementById("tipo4").value;
  // Mensagem só embaixo do histórico
  const msgDiv = document.getElementById("msgComissao");
  msgDiv.innerText = "";
  msgDiv.className = "";

  if (!vendedor_id) {
    msgDiv.innerText = "Selecione um colaborador antes de registrar a comissão.";
    msgDiv.className = "alert alert-danger";
    return;
  }

  const res = await fetch(`${API_URL}/comissoes/add`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Authorization: `Bearer ${getToken()}`
    },
    body: JSON.stringify({
      vendedor_id,
      mes_referencia,
      PREMIO_ISC: tipo1,
      PREMIACAO_META: tipo2,
      PREMIO: tipo3,
      GRATIFICACAO: tipo4
    })
  });

  const data = await res.json();
  msgDiv.innerText = data.msg || "Erro ao salvar";
  msgDiv.className = res.ok ? "alert alert-success" : "alert alert-danger";
}
